#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Bubble colorsMod01.fsh    by      johnowhitaker
//https://www.shadertoy.com/view/Wcf3R8
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const vec3 colormap[500] = vec3[](
    vec3(0.000000, 0.000000, 0.000000),
    vec3(0.027914, 0.028992, 0.035184),
    vec3(0.055811, 0.057960, 0.070324),
    vec3(0.083675, 0.086880, 0.105375),
    vec3(0.111488, 0.115730, 0.140293),
    vec3(0.139236, 0.144486, 0.175033),
    vec3(0.166899, 0.173123, 0.209552),
    vec3(0.194463, 0.201620, 0.243806),
    vec3(0.221911, 0.229952, 0.277752),
    vec3(0.249226, 0.258096, 0.311346),
    vec3(0.276392, 0.286029, 0.344547),
    vec3(0.303393, 0.313729, 0.377312),
    vec3(0.330212, 0.341173, 0.409600),
    vec3(0.356834, 0.368338, 0.441370),
    vec3(0.383243, 0.395202, 0.472582),
    vec3(0.409423, 0.421743, 0.503197),
    vec3(0.435358, 0.447939, 0.533174),
    vec3(0.461034, 0.473769, 0.562478),
    vec3(0.486433, 0.499211, 0.591070),
    vec3(0.511543, 0.524245, 0.618915),
    vec3(0.536346, 0.548849, 0.645976),
    vec3(0.560830, 0.573003, 0.672221),
    vec3(0.584978, 0.596688, 0.697615),
    vec3(0.608778, 0.619884, 0.722127),
    vec3(0.632214, 0.642571, 0.745725),
    vec3(0.655273, 0.664730, 0.768380),
    vec3(0.677941, 0.686344, 0.790062),
    vec3(0.700204, 0.707393, 0.810744),
    vec3(0.722049, 0.727861, 0.830401),
    vec3(0.743464, 0.747729, 0.849006),
    vec3(0.764436, 0.766982, 0.866537),
    vec3(0.784951, 0.785604, 0.882971),
    vec3(0.804998, 0.803577, 0.898287),
    vec3(0.824565, 0.820887, 0.912465),
    vec3(0.843640, 0.837520, 0.925487),
    vec3(0.862212, 0.853460, 0.937337),
    vec3(0.880270, 0.868695, 0.948000),
    vec3(0.897803, 0.883211, 0.957461),
    vec3(0.914800, 0.896995, 0.965708),
    vec3(0.931252, 0.910036, 0.972731),
    vec3(0.947148, 0.922321, 0.978520),
    vec3(0.962478, 0.933840, 0.983068),
    vec3(0.977234, 0.944583, 0.986368),
    vec3(0.991407, 0.954540, 0.988415),
    vec3(1.000000, 0.963702, 0.989207),
    vec3(1.000000, 0.972061, 0.988742),
    vec3(1.000000, 0.979608, 0.987020),
    vec3(1.000000, 0.986336, 0.984042),
    vec3(1.000000, 0.992240, 0.979811),
    vec3(1.000000, 0.997312, 0.974331),
    vec3(1.000000, 1.000000, 0.967610),
    vec3(1.000000, 1.000000, 0.959653),
    vec3(1.000000, 1.000000, 0.950469),
    vec3(1.000000, 1.000000, 0.940070),
    vec3(1.000000, 1.000000, 0.928467),
    vec3(1.000000, 1.000000, 0.915672),
    vec3(1.000000, 1.000000, 0.901700),
    vec3(1.000000, 1.000000, 0.886566),
    vec3(1.000000, 1.000000, 0.870288),
    vec3(1.000000, 1.000000, 0.852884),
    vec3(1.000000, 0.997251, 0.834371),
    vec3(1.000000, 0.992137, 0.814771),
    vec3(1.000000, 0.986175, 0.794104),
    vec3(1.000000, 0.979371, 0.772392),
    vec3(1.000000, 0.971727, 0.749657),
    vec3(1.000000, 0.963250, 0.725923),
    vec3(1.000000, 0.953944, 0.701211),
    vec3(1.000000, 0.943816, 0.675545),
    vec3(1.000000, 0.932872, 0.648948),
    vec3(1.000000, 0.921119, 0.621441),
    vec3(1.000000, 0.908567, 0.593046),
    vec3(1.000000, 0.895222, 0.563779),
    vec3(1.000000, 0.881095, 0.533657),
    vec3(1.000000, 0.866195, 0.502690),
    vec3(1.000000, 0.850532, 0.470881),
    vec3(1.000000, 0.834117, 0.438223),
    vec3(1.000000, 0.816961, 0.404694),
    vec3(1.000000, 0.799076, 0.370248),
    vec3(1.000000, 0.780473, 0.334800),
    vec3(1.000000, 0.761165, 0.298204),
    vec3(1.000000, 0.741164, 0.260197),
    vec3(1.000000, 0.720483, 0.220290),
    vec3(1.000000, 0.699135, 0.177476),
    vec3(1.000000, 0.677132, 0.129218),
    vec3(1.000000, 0.654487, 0.064816),
    vec3(0.990135, 0.631213, 0.000000),
    vec3(0.975375, 0.607321, 0.000000),
    vec3(0.959952, 0.582821, 0.000000),
    vec3(0.943870, 0.557724, 0.000000),
    vec3(0.927130, 0.532037, 0.000000),
    vec3(0.909738, 0.505765, 0.000000),
    vec3(0.891696, 0.478911, 0.000000),
    vec3(0.873007, 0.451472, 0.000000),
    vec3(0.853674, 0.423439, 0.042572),
    vec3(0.833700, 0.394794, 0.117545),
    vec3(0.813084, 0.365503, 0.167777),
    vec3(0.791830, 0.335514, 0.211514),
    vec3(0.769935, 0.304743, 0.252000),
    vec3(0.747400, 0.273052, 0.290437),
    vec3(0.724221, 0.240212, 0.327392),
    vec3(0.700393, 0.205819, 0.363163),
    vec3(0.675909, 0.169088, 0.397917),
    vec3(0.650759, 0.128217, 0.431749),
    vec3(0.624928, 0.077151, 0.464713),
    vec3(0.598396, 0.000000, 0.496836),
    vec3(0.571138, 0.000000, 0.528128),
    vec3(0.543117, 0.000000, 0.558587),
    vec3(0.514287, 0.000000, 0.588205),
    vec3(0.484584, 0.000000, 0.616969),
    vec3(0.453922, 0.000000, 0.644861),
    vec3(0.422179, 0.000000, 0.671861),
    vec3(0.389187, 0.000000, 0.697949),
    vec3(0.354697, 0.000000, 0.723102),
    vec3(0.318333, 0.000000, 0.747298),
    vec3(0.279482, 0.084249, 0.770514),
    vec3(0.237060, 0.133592, 0.792729),
    vec3(0.188838, 0.174026, 0.813919),
    vec3(0.128669, 0.210646, 0.834063),
    vec3(0.000000, 0.245071, 0.853142),
    vec3(0.000000, 0.278024, 0.871134),
    vec3(0.000000, 0.309881, 0.888022),
    vec3(0.000000, 0.340857, 0.903787),
    vec3(0.000000, 0.371080, 0.918412),
    vec3(0.000000, 0.400630, 0.931883),
    vec3(0.000000, 0.429556, 0.944185),
    vec3(0.000000, 0.457885, 0.955304),
    vec3(0.000000, 0.485635, 0.965229),
    vec3(0.000000, 0.512811, 0.973949),
    vec3(0.000000, 0.539413, 0.981456),
    vec3(0.000000, 0.565438, 0.987742),
    vec3(0.000000, 0.590878, 0.992800),
    vec3(0.000000, 0.615722, 0.996625),
    vec3(0.000000, 0.639959, 0.999215),
    vec3(0.000000, 0.663576, 1.000000),
    vec3(0.000000, 0.686559, 1.000000),
    vec3(0.000000, 0.708893, 0.999555),
    vec3(0.000000, 0.730565, 0.997194),
    vec3(0.000000, 0.751558, 0.993602),
    vec3(0.110508, 0.771858, 0.988784),
    vec3(0.178609, 0.791450, 0.982746),
    vec3(0.230821, 0.810320, 0.975495),
    vec3(0.276224, 0.828452, 0.967042),
    vec3(0.317673, 0.845833, 0.957397),
    vec3(0.356475, 0.862449, 0.946572),
    vec3(0.393340, 0.878286, 0.934580),
    vec3(0.428696, 0.893333, 0.921437),
    vec3(0.462817, 0.907576, 0.907158),
    vec3(0.495886, 0.921004, 0.891760),
    vec3(0.528030, 0.933606, 0.875261),
    vec3(0.559338, 0.945371, 0.857681),
    vec3(0.589874, 0.956290, 0.839040),
    vec3(0.619683, 0.966354, 0.819359),
    vec3(0.648796, 0.975553, 0.798661),
    vec3(0.677235, 0.983881, 0.776969),
    vec3(0.705014, 0.991330, 0.754306),
    vec3(0.732142, 0.997893, 0.730697),
    vec3(0.758622, 1.000000, 0.706167),
    vec3(0.784455, 1.000000, 0.680739),
    vec3(0.809637, 1.000000, 0.654439),
    vec3(0.834166, 1.000000, 0.627291),
    vec3(0.858033, 1.000000, 0.599318),
    vec3(0.881232, 1.000000, 0.570543),
    vec3(0.903753, 1.000000, 0.540986),
    vec3(0.925587, 1.000000, 0.510662),
    vec3(0.946722, 1.000000, 0.479584),
    vec3(0.967148, 1.000000, 0.447757),
    vec3(0.986854, 1.000000, 0.415175),
    vec3(1.000000, 1.000000, 0.381819),
    vec3(1.000000, 1.000000, 0.347642),
    vec3(1.000000, 0.995143, 0.312562),
    vec3(1.000000, 0.988199, 0.276426),
    vec3(1.000000, 0.980376, 0.238962),
    vec3(1.000000, 0.971679, 0.199640),
    vec3(1.000000, 0.962118, 0.157321),
    vec3(1.000000, 0.951701, 0.108860),
    vec3(1.000000, 0.940437, 0.034854),
    vec3(1.000000, 0.928336, 0.000000),
    vec3(1.000000, 0.915409, 0.000000),
    vec3(1.000000, 0.901669, 0.000000),
    vec3(1.000000, 0.887126, 0.000000),
    vec3(1.000000, 0.871794, 0.000000),
    vec3(1.000000, 0.855688, 0.000000),
    vec3(1.000000, 0.838820, 0.000000),
    vec3(1.000000, 0.821207, 0.025874),
    vec3(1.000000, 0.802864, 0.105271),
    vec3(1.000000, 0.783807, 0.153952),
    vec3(1.000000, 0.764053, 0.196116),
    vec3(1.000000, 0.743619, 0.235129),
    vec3(1.000000, 0.722524, 0.272191),
    vec3(1.000000, 0.700785, 0.307853),
    vec3(1.000000, 0.678421, 0.342400),
    vec3(1.000000, 0.655452, 0.375990),
    vec3(1.000000, 0.631897, 0.408713),
    vec3(1.000000, 0.607775, 0.440618),
    vec3(1.000000, 0.583106, 0.471730),
    vec3(1.000000, 0.557912, 0.502058),
    vec3(1.000000, 0.532210, 0.531601),
    vec3(1.000000, 0.506021, 0.560350),
    vec3(1.000000, 0.479364, 0.588292),
    vec3(1.000000, 0.452257, 0.615413),
    vec3(1.000000, 0.424717, 0.641694),
    vec3(1.000000, 0.396760, 0.667116),
    vec3(1.000000, 0.368396, 0.691659),
    vec3(1.000000, 0.339636, 0.715302),
    vec3(1.000000, 0.310479, 0.738026),
    vec3(1.000000, 0.280917, 0.759811),
    vec3(1.000000, 0.250924, 0.780637),
    vec3(1.000000, 0.220446, 0.800485),
    vec3(1.000000, 0.189373, 0.819338),
    vec3(1.000000, 0.157485, 0.837178),
    vec3(0.991283, 0.124299, 0.853990),
    vec3(0.969721, 0.088530, 0.869757),
    vec3(0.947145, 0.044566, 0.884466),
    vec3(0.923546, 0.000000, 0.898104),
    vec3(0.898913, 0.000000, 0.910660),
    vec3(0.873232, 0.000000, 0.922122),
    vec3(0.846485, 0.000000, 0.932483),
    vec3(0.818648, 0.000000, 0.941734),
    vec3(0.789691, 0.065904, 0.949868),
    vec3(0.759575, 0.104523, 0.956881),
    vec3(0.728251, 0.138641, 0.962769),
    vec3(0.695653, 0.170873, 0.967529),
    vec3(0.661698, 0.202025, 0.971162),
    vec3(0.626273, 0.232433, 0.973666),
    vec3(0.589230, 0.262258, 0.975046),
    vec3(0.550365, 0.291580, 0.975303),
    vec3(0.509391, 0.320442, 0.974443),
    vec3(0.465892, 0.348862, 0.972473),
    vec3(0.419239, 0.376844, 0.969400),
    vec3(0.368404, 0.404386, 0.965234),
    vec3(0.311544, 0.431479, 0.959986),
    vec3(0.244732, 0.458111, 0.953669),
    vec3(0.156011, 0.484269, 0.946296),
    vec3(0.000000, 0.509936, 0.937884),
    vec3(0.000000, 0.535096, 0.928449),
    vec3(0.000000, 0.559732, 0.918010),
    vec3(0.000000, 0.583826, 0.906588),
    vec3(0.000000, 0.607361, 0.894205),
    vec3(0.000000, 0.630320, 0.880884),
    vec3(0.000000, 0.652684, 0.866651),
    vec3(0.000000, 0.674439, 0.851533),
    vec3(0.000000, 0.695566, 0.835559),
    vec3(0.000000, 0.716050, 0.818760),
    vec3(0.000000, 0.735875, 0.801170),
    vec3(0.000000, 0.755025, 0.782823),
    vec3(0.000000, 0.773488, 0.763758),
    vec3(0.000000, 0.791247, 0.744013),
    vec3(0.000000, 0.808291, 0.723632),
    vec3(0.000000, 0.824607, 0.702661),
    vec3(0.000000, 0.840182, 0.681150),
    vec3(0.000000, 0.855005, 0.659150),
    vec3(0.000000, 0.869066, 0.636721),
    vec3(0.000000, 0.882355, 0.613924),
    vec3(0.000000, 0.894863, 0.590829),
    vec3(0.000000, 0.906582, 0.567511),
    vec3(0.000000, 0.917503, 0.544054),
    vec3(0.000000, 0.927621, 0.520553),
    vec3(0.000000, 0.936929, 0.497114),
    vec3(0.000000, 0.945423, 0.473857),
    vec3(0.000000, 0.953097, 0.450920),
    vec3(0.000000, 0.959949, 0.428461),
    vec3(0.000000, 0.965975, 0.406662),
    vec3(0.166342, 0.971174, 0.385735),
    vec3(0.253294, 0.975546, 0.365922),
    vec3(0.319957, 0.979089, 0.347497),
    vec3(0.377093, 0.981804, 0.330771),
    vec3(0.428390, 0.983694, 0.316079),
    vec3(0.475611, 0.984760, 0.303769),
    vec3(0.519742, 0.985005, 0.294180),
    vec3(0.561396, 0.984435, 0.287610),
    vec3(0.600973, 0.983053, 0.284275),
    vec3(0.638751, 0.980867, 0.284283),
    vec3(0.674927, 0.977881, 0.287610),
    vec3(0.709644, 0.974106, 0.294104),
    vec3(0.743008, 0.969547, 0.303511),
    vec3(0.775100, 0.964216, 0.315507),
    vec3(0.805979, 0.958123, 0.329737),
    vec3(0.835690, 0.951279, 0.345844),
    vec3(0.864270, 0.943695, 0.363489),
    vec3(0.891743, 0.935385, 0.382368),
    vec3(0.918129, 0.926364, 0.402207),
    vec3(0.943443, 0.916645, 0.422773),
    vec3(0.967694, 0.906245, 0.443860),
    vec3(0.990890, 0.895182, 0.465295),
    vec3(1.000000, 0.883471, 0.486927),
    vec3(1.000000, 0.871134, 0.508625),
    vec3(1.000000, 0.858190, 0.530278),
    vec3(1.000000, 0.844659, 0.551788),
    vec3(1.000000, 0.830565, 0.573069),
    vec3(1.000000, 0.815931, 0.594045),
    vec3(1.000000, 0.800781, 0.614650),
    vec3(1.000000, 0.785143, 0.634823),
    vec3(1.000000, 0.769044, 0.654510),
    vec3(1.000000, 0.752512, 0.673664),
    vec3(1.000000, 0.735581, 0.692241),
    vec3(1.000000, 0.718281, 0.710201),
    vec3(1.000000, 0.700649, 0.727509),
    vec3(1.000000, 0.682721, 0.744132),
    vec3(1.000000, 0.664538, 0.760041),
    vec3(1.000000, 0.646142, 0.775208),
    vec3(1.000000, 0.627578, 0.789610),
    vec3(1.000000, 0.608898, 0.803224),
    vec3(1.000000, 0.590153, 0.816032),
    vec3(1.000000, 0.571402, 0.828015),
    vec3(1.000000, 0.552708, 0.839158),
    vec3(1.000000, 0.534139, 0.849448),
    vec3(1.000000, 0.515772, 0.858872),
    vec3(1.000000, 0.497688, 0.867422),
    vec3(1.000000, 0.479979, 0.875089),
    vec3(1.000000, 0.462744, 0.881866),
    vec3(1.000000, 0.446090, 0.887751),
    vec3(1.000000, 0.430137, 0.892738),
    vec3(1.000000, 0.415014, 0.896828),
    vec3(1.000000, 0.400856, 0.900021),
    vec3(1.000000, 0.387808, 0.902320),
    vec3(1.000000, 0.376021, 0.903727),
    vec3(1.000000, 0.365643, 0.904249),
    vec3(1.000000, 0.356821, 0.903892),
    vec3(1.000000, 0.349688, 0.902666),
    vec3(1.000000, 0.344359, 0.900581),
    vec3(1.000000, 0.340920, 0.897649),
    vec3(1.000000, 0.339424, 0.893883),
    vec3(1.000000, 0.339885, 0.889300),
    vec3(1.000000, 0.342278, 0.883916),
    vec3(1.000000, 0.346538, 0.877750),
    vec3(1.000000, 0.352568, 0.870823),
    vec3(0.994533, 0.360242, 0.863157),
    vec3(0.972518, 0.369420, 0.854777),
    vec3(0.949609, 0.379947, 0.845709),
    vec3(0.925812, 0.391667, 0.835980),
    vec3(0.901135, 0.404425, 0.825620),
    vec3(0.875581, 0.418074, 0.814663),
    vec3(0.849155, 0.432473, 0.803141),
    vec3(0.821856, 0.447492, 0.791092),
    vec3(0.793682, 0.463015, 0.778554),
    vec3(0.764626, 0.478932, 0.765569),
    vec3(0.734677, 0.495146, 0.752180),
    vec3(0.703815, 0.511569, 0.738434),
    vec3(0.672013, 0.528122, 0.724380),
    vec3(0.639233, 0.544734, 0.710071),
    vec3(0.605420, 0.561340, 0.695562),
    vec3(0.570498, 0.577883, 0.680912),
    vec3(0.534362, 0.594310, 0.666184),
    vec3(0.496862, 0.610575, 0.651443),
    vec3(0.457783, 0.626633, 0.636760),
    vec3(0.416809, 0.642447, 0.622209),
    vec3(0.373452, 0.657981, 0.607866),
    vec3(0.326909, 0.673203, 0.593815),
    vec3(0.275732, 0.688083, 0.580139),
    vec3(0.216856, 0.702595, 0.566928),
    vec3(0.141216, 0.716714, 0.554272),
    vec3(0.000000, 0.730418, 0.542266),
    vec3(0.000000, 0.743686, 0.531003),
    vec3(0.000000, 0.756500, 0.520577),
    vec3(0.000000, 0.768842, 0.511081),
    vec3(0.000000, 0.780698, 0.502603),
    vec3(0.000000, 0.792052, 0.495223),
    vec3(0.000000, 0.802893, 0.489016),
    vec3(0.000000, 0.813210, 0.484043),
    vec3(0.000000, 0.822991, 0.480353),
    vec3(0.000000, 0.832227, 0.477980),
    vec3(0.000000, 0.840912, 0.476940),
    vec3(0.000000, 0.849038, 0.477232),
    vec3(0.000000, 0.856599, 0.478838),
    vec3(0.000000, 0.863591, 0.481722),
    vec3(0.000000, 0.870009, 0.485835),
    vec3(0.000000, 0.875850, 0.491111),
    vec3(0.000000, 0.881114, 0.497475),
    vec3(0.000000, 0.885797, 0.504842),
    vec3(0.000000, 0.889901, 0.513123),
    vec3(0.000000, 0.893425, 0.522222),
    vec3(0.000000, 0.896371, 0.532044),
    vec3(0.000000, 0.898741, 0.542493),
    vec3(0.043685, 0.900539, 0.553474),
    vec3(0.161972, 0.901768, 0.564895),
    vec3(0.228488, 0.902432, 0.576668),
    vec3(0.282375, 0.902537, 0.588710),
    vec3(0.329738, 0.902089, 0.600940),
    vec3(0.372942, 0.901095, 0.613284),
    vec3(0.413172, 0.899562, 0.625671),
    vec3(0.451109, 0.897500, 0.638037),
    vec3(0.487182, 0.894916, 0.650320),
    vec3(0.521672, 0.891821, 0.662465),
    vec3(0.554776, 0.888226, 0.674417),
    vec3(0.586634, 0.884142, 0.686130),
    vec3(0.617347, 0.879580, 0.697559),
    vec3(0.646989, 0.874554, 0.708663),
    vec3(0.675618, 0.869077, 0.719405),
    vec3(0.703275, 0.863164, 0.729750),
    vec3(0.729992, 0.856829, 0.739667),
    vec3(0.755795, 0.850088, 0.749129),
    vec3(0.780700, 0.842958, 0.758108),
    vec3(0.804722, 0.835456, 0.766583),
    vec3(0.827871, 0.827600, 0.774532),
    vec3(0.850154, 0.819408, 0.781938),
    vec3(0.871578, 0.810902, 0.788784),
    vec3(0.892145, 0.802101, 0.795057),
    vec3(0.911858, 0.793026, 0.800746),
    vec3(0.930719, 0.783699, 0.805839),
    vec3(0.948729, 0.774144, 0.810331),
    vec3(0.965887, 0.764385, 0.814215),
    vec3(0.982195, 0.754445, 0.817487),
    vec3(0.997652, 0.744352, 0.820145),
    vec3(1.000000, 0.734132, 0.822189),
    vec3(1.000000, 0.723811, 0.823620),
    vec3(1.000000, 0.713419, 0.824441),
    vec3(1.000000, 0.702986, 0.824658),
    vec3(1.000000, 0.692541, 0.824277),
    vec3(1.000000, 0.682116, 0.823307),
    vec3(1.000000, 0.671743, 0.821756),
    vec3(1.000000, 0.661456, 0.819636),
    vec3(1.000000, 0.651288, 0.816961),
    vec3(1.000000, 0.641275, 0.813746),
    vec3(1.000000, 0.631452, 0.810006),
    vec3(1.000000, 0.621855, 0.805759),
    vec3(1.000000, 0.612521, 0.801026),
    vec3(1.000000, 0.603486, 0.795827),
    vec3(1.000000, 0.594787, 0.790185),
    vec3(1.000000, 0.586461, 0.784125),
    vec3(1.000000, 0.578545, 0.777671),
    vec3(1.000000, 0.571073, 0.770853),
    vec3(1.000000, 0.564080, 0.763699),
    vec3(1.000000, 0.557600, 0.756240),
    vec3(1.000000, 0.551662, 0.748509),
    vec3(1.000000, 0.546295, 0.740538),
    vec3(1.000000, 0.541526, 0.732365),
    vec3(1.000000, 0.537377, 0.724025),
    vec3(1.000000, 0.533866, 0.715557),
    vec3(1.000000, 0.531010, 0.707002),
    vec3(1.000000, 0.528820, 0.698400),
    vec3(1.000000, 0.527301, 0.689793),
    vec3(1.000000, 0.526456, 0.681226),
    vec3(1.000000, 0.526282, 0.672742),
    vec3(1.000000, 0.526773, 0.664388),
    vec3(1.000000, 0.527917, 0.656208),
    vec3(1.000000, 0.529698, 0.648249),
    vec3(1.000000, 0.532097, 0.640556),
    vec3(1.000000, 0.535091, 0.633176),
    vec3(1.000000, 0.538653, 0.626153),
    vec3(0.998356, 0.542754, 0.619530),
    vec3(0.984874, 0.547364, 0.613350),
    vec3(0.970858, 0.552449, 0.607651),
    vec3(0.956327, 0.557975, 0.602472),
    vec3(0.941301, 0.563908, 0.597845),
    vec3(0.925803, 0.570211, 0.593801),
    vec3(0.909854, 0.576849, 0.590364),
    vec3(0.893478, 0.583785, 0.587557),
    vec3(0.876699, 0.590985, 0.585395),
    vec3(0.859543, 0.598415, 0.583889),
    vec3(0.842034, 0.606039, 0.583043),
    vec3(0.824203, 0.613826, 0.582858),
    vec3(0.806076, 0.621743, 0.583326),
    vec3(0.787686, 0.629760, 0.584437),
    vec3(0.769063, 0.637848, 0.586173),
    vec3(0.750242, 0.645979, 0.588513),
    vec3(0.731259, 0.654125, 0.591430),
    vec3(0.712153, 0.662261, 0.594893),
    vec3(0.692962, 0.670364, 0.598870),
    vec3(0.673732, 0.678409, 0.603323),
    vec3(0.654509, 0.686377, 0.608213),
    vec3(0.635343, 0.694245, 0.613500),
    vec3(0.616287, 0.701995, 0.619140),
    vec3(0.597400, 0.709608, 0.625091),
    vec3(0.578745, 0.717069, 0.631310),
    vec3(0.560390, 0.724360, 0.637753),
    vec3(0.542409, 0.731468, 0.644376),
    vec3(0.524883, 0.738377, 0.651138),
    vec3(0.507898, 0.745076, 0.657998),
    vec3(0.491547, 0.751552, 0.664915),
    vec3(0.475930, 0.757795, 0.671850),
    vec3(0.461155, 0.763794, 0.678767),
    vec3(0.447333, 0.769539, 0.685630),
    vec3(0.434580, 0.775023, 0.692404),
    vec3(0.423014, 0.780237, 0.699059),
    vec3(0.412754, 0.785174, 0.705563),
    vec3(0.403911, 0.789829, 0.711889),
    vec3(0.396590, 0.794195, 0.718009),
    vec3(0.390879, 0.798267, 0.723900),
    vec3(0.386850, 0.802041, 0.729537),
    vec3(0.384550, 0.805514, 0.734901),
    vec3(0.384000, 0.808682, 0.739973),
    vec3(0.385193, 0.811542, 0.744733),
    vec3(0.388095, 0.814094, 0.749168),
    vec3(0.392644, 0.816335, 0.753263),
    vec3(0.398757, 0.818266, 0.757006),
    vec3(0.406334, 0.819884, 0.760386),
    vec3(0.415261, 0.821192, 0.763394),
    vec3(0.425417, 0.822190, 0.766023),
    vec3(0.436678, 0.822878, 0.768268),
    vec3(0.448920, 0.823260, 0.770124),
    vec3(0.462024, 0.823337, 0.771589),
    vec3(0.475874, 0.823112, 0.772661),
    vec3(0.490363, 0.822588, 0.773341),
    vec3(0.505390, 0.821770, 0.773631),
    vec3(0.520862, 0.820662, 0.773533),
    vec3(0.536694, 0.819268, 0.773053),
    vec3(0.552808, 0.817593, 0.772197),
    vec3(0.569133, 0.815643, 0.770971),
    vec3(0.585604, 0.813425, 0.769385),
    vec3(0.602163, 0.810945, 0.767449)
);
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    // Normalize pixel coordinates (from 0 to 1)
    vec2 uv = fragCoord.xy / iResolution.xy;
    
    // Map uv to coordinate space [-10, 10] (adjust if needed)
    float x = mix(-10.0, 10.0, uv.x);
    float y = mix(-10.0, 10.0, uv.y);
    
    // Create animated interference patterns
    float wave = sin(0.5*x + 0.7*y + iTime)
               + 0.5 * sin(0.8*x - 0.2*y + 2.0 + iTime)
               + 0.7 * sin(0.3*x + 0.9*y + 1.0 + iTime)
               + 0.8 * sin(0.5 * length(vec2(x,y)) + iTime);
               
    // In the original Python, the combined wave was normalized using min and max.
    // Here, knowing the maximum sum (3.0) and minimum (-3.0), we can map:
    float normWave = (wave + 3.0) / 6.0;
    // float normWave = (wave - 0.5 + 3.0) / 8.0;
    
    // Determine an index into the colormap
    // Use N-1 because our indices run from 0 to N-1.
    int index = int(clamp(floor(normWave * 499.0), 0.0, 499.0));
    
    // Get the color from our embedded colormap.
    vec3 color = colormap[index];
    
    fragColor = vec4(color, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

